<?PHP
if (! defined ( 'BASEPATH' )) exit ( 'No direct script access allowed' );

/**
 * @package direct-as-a-service
 * @subpackage models
 * @filesource
 */

/** */
require_once 'disclosure.php';

/**
 * @package direct-as-a-service
 * @subpackage models           
 */
class Attachment_disclosure extends Disclosure {
	protected $_attachment;
	
/////////////////////////////
// GETTERS
/////////////////////////////
	
	public function attachment(){
		if(!isset($this->_attachment) && !$this->property_is_empty('hash') && $this->has_message()){
			$message = $this->message;
			foreach($message->attachment_files as $filename => $binary_string){
				if(sha1($binary_string) == $this->hash){
					$this->_attachment = Attachment::create($filename, $binary_string, array('message_id' => $message->id));
				} 
			}
		}
		return $this->_attachment;
	}
	
	
	public function first(){
		if(is_a($this->attachment, 'Patient_document_attachment') && is_object($this->attachment->parser)) 
			$this->_values['first'] = implode_nonempty(' ', $this->attachment->parser->given_names);
		if(array_key_exists('first', $this->_values)) return $this->_values['first'];
	}
	
	public function last(){
		if(is_a($this->attachment, 'Patient_document_attachment') && is_object($this->attachment->parser)) 
			$this->_values['last'] = $this->attachment->parser->family_name;
		if(array_key_exists('last', $this->_values)) return $this->_values['last'];			
	}
	
	public function title(){
		if(is_a($this->attachment, 'Patient_document_attachment') && is_object($this->attachment->parser)) 
			$this->_values['title'] = $this->attachment->parser->title;
		if(array_key_exists('title', $this->_values)) return $this->_values['title'];		
	}
	
	public function readonly_fields(){
		$readonly_fields = array_unique($this->_merge_with_parent_array('readonly_fields'));
		unset($readonly_fields[array_search('hash', $readonly_fields)]); //hash is settable for attachment disclosure
		return $readonly_fields; 
	}	
	
	public function received_from(){
		if(is_a($this->attachment, 'Patient_document_attachment') && is_object($this->attachment->parser)) 
			 $this->_values['received_from'] = $this->attachment->parser->organization;
		if(array_key_exists('received_from', $this->_values)) return $this->_values['received_from'];			
	}
	
	public function patient_id(){
		if(is_a($this->attachment, 'Patient_document_attachment') && !is_a($this->attachment, 'CCR_attachment') && is_object($this->attachment->parser)) 
			$this->_values['patient_id'] = $this->attachment->parser->patient_icn;
		if(array_key_exists('patient_id', $this->_values)) return $this->_values['patient_id'];
	}		


/////////////////////
// SETTERS
////////////////////			
		
#TODO - set hash -> need to change the values
#TODO - set message_table_id -> need to change the values

	public function set_hash($value, $offset=0){
		if(!is_string($value) || strlen($value) != 40)
			return $this->error->should_be_an_attachment_hash($value, $offset+1);
			
		$message = $this->message;
		if(!Message::is_an_entity($message)) 
			return $this->error->warning("I can't set the hash before a message has been set for ".$this->describe(), $offset+1);
		if(empty($message->attachments_matching_hash($value))) 
			return $this->error->should_be_an_x($value, 'hash for an attachment on '.$message->describe(), $offset+1); 
						
		//wipe the content of the attachment content and the attachment parser, force a reload	
		if(isset($this->_attachment)) $this->_attachment = null;		
		$this->_set_field_value('hash', $value, $offset+1);
	}
		

	
/////////////////////
// DATA MANAGEMENT
////////////////////	
	
	
	protected function _values_for_save(){
		$values_for_save = parent::_values_for_save();
		
		//for patient document attachments, the values parsed from the attachment are the authorititive values - refresh if attachment changed
		if(is_a($this->attachment, 'Patient_document_attachment') && array_key_exists('hash', $values_for_save)){
			$values_for_save = array_merge($values_for_save, $this->values( array('first', 'last', 'title', 'received_from', 'patient_id')));
		}
		
		return $values_for_save;
	}
	

	/**
	* Validates that the values match an attachment that requires disclosure on an existing message; if no recipient is specified, the message must be a draft.
	* @return boolean
	*/
	protected function _values_are_valid_for_create_and_update(){	
		if(!parent::_values_are_valid_for_create_and_update()) return false;
		
		
		
		$required_fields = array('hash');
		foreach($required_fields as $required_field){
			if($this->property_is_empty($required_field)) return $this->error->warning(get_class($this).'::$'.$required_field.' is a required field, and must be set before saving'); 
		}
		

		return true;
	}
	
///////////////////////////
// STATIC METHODS
///////////////////////////	
	
	/**
	* True if the content provided requires a purpose of disclosure to be provided.
	* @param string The content of an attachment
	*/
	public static function content_requires_disclosure($binary_string){
		if(!is_string($binary_string)) return should_be('string', $binary_string);
		return (validates_as('c32_xml_string', $binary_string) || validates_as('ccda_xml_string', $binary_string) || validates_as('ccr_xml_string', $binary_string));
	}

		
	public static function update_or_create_for_message($message, $values){
		if(!Message::is_an_entity($message)) return should_be('message entity', $message);
		if(!is_array($values) || empty($values)) return should_be('nonempty array', $values);
		if(empty($values['hash'])) return should_be('array with a nonempty entry for a hash', $values);
		
		return parent::update_or_create_for_message($message, $values);
	}
		
}
